package org.msh.etbm.services.mobile.sync;

import org.apache.commons.beanutils.PropertyUtils;
import org.msh.etbm.services.mobile.model.ExamDSTData;
import org.msh.tb.entities.ExamDST;
import org.msh.tb.entities.ExamDSTResult;
import org.msh.tb.entities.Substance;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.DstResult;
import org.msh.tb.login.UserSession;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 14/9/17.
 */
public class ExamDstConsumer extends SyncDataConsumerImpl<ExamDSTData, Integer> {

    @Override
    public Integer consume(Tbunit unit, ExamDSTData data) {
        ExamDST exam = recoverEntity(ExamDST.class, data.getServerId());

        moveLaboratoryExamData(data, exam);

        exam.setSampleNumber(data.getSampleNumber());
        exam.setLaboratory(getLaboratory(data.getLaboratoryId()));
        exam.setDateRelease(data.getDateRelease());
        exam.setMethod(getFieldValue(data.getMethod()));
        exam.setComments(data.getComments());

        getEntityManager().persist(exam);

        updateDSTResults(data, exam);

        return data.getServerId() == null ? exam.getId() : null;
    }

    private void updateDSTResults(ExamDSTData data, ExamDST exam) {
        // delete all existing results, if updating an existing result
        if (exam.getId() != null) {
            getEntityManager().createQuery("delete from ExamDSTResult where exam.id = :examId")
                    .setParameter("examId", exam.getId())
                    .executeUpdate();
        }

        ArrayList<ExamDSTResult> newResults = new ArrayList<ExamDSTResult>();

        // set new results
        for (Substance s : getSubstances()){
            String propName = "result" + s.getAbbrevName().getName1().replace("/", "");

            try {
                DstResult substanceResult = (DstResult) PropertyUtils.getProperty(data, propName);

                if(substanceResult != null) {
                    ExamDSTResult result = new ExamDSTResult();
                    result.setResult(substanceResult);
                    result.setSubstance(s);
                    result.setExam(exam);

                    getEntityManager().persist(result);
                    newResults.add(result);
                }
            } catch (Exception e) {
                System.out.println("Property not found in " + ExamDSTData.class.getCanonicalName() +
                        " = " + propName);
            }
        }

        exam.setResults(newResults);
        getEntityManager().persist(exam);
    }

    private List<Substance> getSubstances(){
        return getEntityManager().createQuery("from Substance where dstResultForm = true and workspace.id = :wsId")
            .setParameter("wsId", UserSession.getWorkspace().getId())
            .getResultList();
    }
}
